/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.integration;

import com.google.auto.service.AutoService;
import dan200.computercraft.client.integration.ShaderMod;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.api.v0.IrisTextVertexSink;
import net.minecraft.class_293;
import net.minecraft.class_5253;

@Environment(value=EnvType.CLIENT)
@AutoService(value={ShaderMod.Provider.class})
public class IrisShaderMod
implements ShaderMod.Provider {
    @Override
    public Optional<ShaderMod> get() {
        return PlatformHelper.get().isModLoaded("iris") ? Optional.of(new Impl()) : Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Impl
    extends ShaderMod {
        private Impl() {
        }

        @Override
        public boolean isRenderingShadowPass() {
            return IrisApi.getInstance().isRenderingShadowPass();
        }

        @Override
        public DirectFixedWidthFontRenderer.QuadEmitter getQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
            return IrisApi.getInstance().getMinorApiRevision() >= 1 ? new IrisQuadEmitter(vertexCount, makeBuffer) : super.getQuadEmitter(vertexCount, makeBuffer);
        }

        @Environment(value=EnvType.CLIENT)
        private static final class IrisQuadEmitter
        implements DirectFixedWidthFontRenderer.QuadEmitter {
            private final IrisTextVertexSink sink;

            private IrisQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
                this.sink = IrisApi.getInstance().createTextVertexSink(vertexCount, makeBuffer);
            }

            @Override
            public class_293 format() {
                return this.sink.getUnderlyingVertexFormat();
            }

            @Override
            public ByteBuffer buffer() {
                return this.sink.getUnderlyingByteBuffer();
            }

            @Override
            public void quad(float x1, float y1, float x2, float y2, float z, int colour, float u1, float v1, float u2, float v2) {
                this.sink.quad(x1, y1, x2, y2, z, class_5253.class_8045.method_60675((int)colour), u1, v1, u2, v2, 0xF000F0);
            }
        }
    }
}

